/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import filenet.vw.toolkit.runtime.VWDuration;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWSIMWorkflowStatTableModel
extends AbstractTableModel {
    public static final int STAT_WORKFLOW_NAME_COL = 0;
    public static final int STAT_WORKFLOW_LAUNCHED_COL = 1;
    public static final int STAT_WORKFLOW_ACTIVE_COL = 2;
    public static final int STAT_WORKFLOW_COMPLETED_COL = 3;
    public static final int STAT_WORKFLOW_COST_COL = 4;
    public static final int STAT_WORKFLOW_AVERAGE_COST_COL = 5;
    public static final int STAT_WORKFLOW_OVERDUE_COL = 6;
    public static final int STAT_WORKFLOW_MIN_CYCLE_COL = 7;
    public static final int STAT_WORKFLOW_MAX_CYCLE_COL = 8;
    public static final int STAT_WORKFLOW_AVERAGE_CYCLE_COL = 9;
    protected VWSIMAnimatorDataModel m_animatorDataModel = null;
    private Vector m_columnNames = new Vector();
    VWTableSorter m_sorter = null;

    public VWSIMWorkflowStatTableModel(VWSIMAnimatorDataModel animatorDataModel) {
        this.createTableSorter();
        this.m_animatorDataModel = animatorDataModel;
        this.initColumnNames();
    }

    VWSIMAnimatorDataModel getDataModel() {
        return this.m_animatorDataModel;
    }

    protected Vector getWorkflows() {
        if (this.m_animatorDataModel != null) {
            return this.m_animatorDataModel.getWorkflows();
        }
        return null;
    }

    private void createTableSorter() {
        this.m_sorter = new VWTableSorter(this){

            public void tableChanged(TableModelEvent e) {
                int col = e.getColumn();
                if (e.getType() == 0 && col != 0 && col != -1) {
                    this.fireTableChanged(e);
                } else {
                    super.tableChanged(e);
                    this.sortByColumn(0);
                }
            }
        };
    }

    void initData() {
        this.fireTableDataChanged();
    }

    public Object getValueAt(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (row == 0) {
            return this.m_animatorDataModel.getScenario();
        }
        return this.getWorkflow(row);
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (row == 0) {
            VWSIMAnimatorScenario scenario = this.m_animatorDataModel.getScenario();
            if (scenario != null) {
                switch (col) {
                    case 0: {
                        return VWSIMResource.s_allWorkflows;
                    }
                    case 1: {
                        return new Integer(scenario.getLaunchedCount());
                    }
                    case 2: {
                        return new Integer(scenario.getActiveCount());
                    }
                    case 3: {
                        return new Integer(scenario.getCompletedCount());
                    }
                    case 6: {
                        return new Integer(scenario.getOverdueCount());
                    }
                    case 4: {
                        return new Double(scenario.getCost());
                    }
                    case 5: {
                        return new Double(scenario.getAverageCost());
                    }
                    case 7: {
                        long minCycle = scenario.getMinCycleTime();
                        if (minCycle != 0L) {
                            return new VWDuration(minCycle).toString();
                        }
                        return null;
                    }
                    case 8: {
                        long maxCycle = scenario.getMaxCycleTime();
                        if (maxCycle != 0L) {
                            return new VWDuration(maxCycle).toString();
                        }
                        return null;
                    }
                    case 9: {
                        long averageCycle = scenario.getAverageCycleTime();
                        if (averageCycle != 0L) {
                            return new VWDuration(averageCycle).toString();
                        }
                        return null;
                    }
                }
            }
        } else {
            VWSIMAnimatorWorkflow workflow = this.getWorkflow(row);
            if (workflow != null) {
                switch (col) {
                    case 0: {
                        return workflow.getName();
                    }
                    case 1: {
                        return new Integer(workflow.getLaunchedCount());
                    }
                    case 2: {
                        return new Integer(workflow.getActiveCount());
                    }
                    case 3: {
                        return new Integer(workflow.getCompletedCount());
                    }
                    case 6: {
                        return new Integer(workflow.getOverdueCount());
                    }
                    case 4: {
                        return new Double(workflow.getCost());
                    }
                    case 5: {
                        return new Double(workflow.getAverageCost());
                    }
                    case 7: {
                        long minCycle = workflow.getMinCycleTime();
                        if (minCycle != 0L) {
                            return new VWDuration(minCycle).toString();
                        }
                        return null;
                    }
                    case 8: {
                        long maxCycle = workflow.getMaxCycleTime();
                        if (maxCycle != 0L) {
                            return new VWDuration(maxCycle).toString();
                        }
                        return null;
                    }
                    case 9: {
                        long averageCycle = workflow.getAverageCycleTime();
                        if (averageCycle != 0L) {
                            return new VWDuration(averageCycle).toString();
                        }
                        return null;
                    }
                }
            }
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement(VWSIMResource.s_workflow_col);
        this.m_columnNames.addElement(VWSIMResource.s_launched_col);
        this.m_columnNames.addElement(VWSIMResource.s_active_col);
        this.m_columnNames.addElement(VWSIMResource.s_completed_col);
        this.m_columnNames.addElement(VWSIMResource.s_cost_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_cost_col);
        this.m_columnNames.addElement(VWSIMResource.s_overdue_col);
        this.m_columnNames.addElement(VWSIMResource.s_min_cycle_col);
        this.m_columnNames.addElement(VWSIMResource.s_max_cycle_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_cycle_col);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 7: 
            case 8: 
            case 9: {
                return String.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return Integer.class;
            }
            case 4: 
            case 5: {
                return Double.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        if (this.getWorkflows() != null) {
            return this.getWorkflows().size() + 1;
        }
        return 0;
    }

    public VWSIMAnimatorWorkflow getWorkflow(int row) {
        Object obj;
        VWSIMAnimatorWorkflow workflow = null;
        Vector workflows = this.getWorkflows();
        if (workflows != null && --row < workflows.size() && (obj = workflows.elementAt(row)) != null && obj instanceof VWSIMAnimatorWorkflow) {
            workflow = (VWSIMAnimatorWorkflow)obj;
        }
        return workflow;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public VWTableSorter getTableSorter() {
        return this.m_sorter;
    }

    void releaseResources() {
        this.m_animatorDataModel = null;
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
        }
        this.m_columnNames = null;
        this.m_sorter = null;
    }
}

